library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

entity AC is
    port (
        LD_AC: in STD_LOGIC;
        INC_AC: in STD_LOGIC;
        CLR_AC: in STD_LOGIC;
        CLK: in STD_LOGIC;
        ACIN: in STD_LOGIC_VECTOR (7 downto 0);
        AC: out STD_LOGIC_VECTOR (7 downto 0)
    );
end AC;

architecture AC_arch of AC is
signal internal_count:std_logic_vector(7 downto 0);
begin
AC<=internal_count;
process (CLR_AC,LD_AC,INC_AC,ACIN,CLK)
begin
if (clk'event and clk ='1') then
	if (CLR_AC='1') then
		internal_count<="00000000";
	else
		if (LD_AC = '1') then
			internal_count <= ACIN;
		else
			if (INC_AC='1') then
				internal_count<=(internal_count + 1);
			end if;
		end if;
  	end if;
  	
end if;
end process;
end AC_arch;
