library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

entity AR is
    port (
        LD_AR: in STD_LOGIC;
        INC_AR: in STD_LOGIC;
        CLR_AR: in STD_LOGIC;
        CLK: in STD_LOGIC;
        ARIN: in STD_LOGIC_VECTOR (7 downto 0);
        AR: out STD_LOGIC_VECTOR (7 downto 0)
    );
end AR;

architecture AR_arch of AR is
signal internal_count:std_logic_vector(7 downto 0);
begin
AR<=internal_count;
process (CLR_AR,LD_AR,INC_AR,ARIN,CLK)
begin
if (clk'event and clk ='1') then
	if (CLR_AR='1') then
		internal_count<="00000000";
	else
		if (LD_AR = '1') then
			internal_count <= ARIN;
		else
			if (INC_AR='1') then
				internal_count<=(internal_count + 1);
			end if;
		end if;
  	end if;
  	
end if;
end process;
end AR_arch;
