library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

entity DR is
    port (
        LD_DR: in STD_LOGIC;
        INC_DR: in STD_LOGIC;
        CLR_DR: in STD_LOGIC;
        CLK: in STD_LOGIC;
        DRIN: in STD_LOGIC_VECTOR (7 downto 0);
        DR: out STD_LOGIC_VECTOR (7 downto 0)
    );
end DR;

architecture DR_arch of DR is
signal internal_count:std_logic_vector(7 downto 0);
begin
DR<=internal_count;
process (CLR_DR,LD_DR,INC_DR,DRIN,CLK)
begin
if (clk'event and clk ='1') then
	if (CLR_DR='1') then
		internal_count<="00000000";
	else
		if (LD_DR = '1') then
			internal_count <= DRIN;
		else
			if (INC_DR='1') then
				internal_count<=(internal_count + 1);
			end if;
		end if;
  	end if;
  	
end if;
end process;
end DR_arch;
