library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

entity PROGRAMCOUNTER is
    port (
        LD_PC: in STD_LOGIC;
        INC_PC: in STD_LOGIC;
        CLR_PC: in STD_LOGIC;
        CLK: in STD_LOGIC;
        PCIN: in STD_LOGIC_VECTOR (7 downto 0);
        PC: out STD_LOGIC_VECTOR (7 downto 0)
    );
end PROGRAMCOUNTER;

architecture PROGRAMCOUNTER_arch of PROGRAMCOUNTER is
signal internal_count:std_logic_vector(7 downto 0);
begin
PC<=internal_count;
process (CLR_PC,LD_PC,INC_PC,PCIN,CLK)
begin
if (clk'event and clk ='1') then
	if (CLR_PC='1') then
		internal_count<="00000000";
	else
		if (LD_PC = '1') then
			internal_count <= PCIN;
		else
			if (INC_PC='1') then
				internal_count<=(internal_count + 1);
			end if;
		end if;
  	end if;
  	
end if;
end process;
end PROGRAMCOUNTER_arch;
