library IEEE;
use IEEE.std_logic_1164.all;

entity SequenceCounter is
    port (
        CLR_SC: in STD_LOGIC;
        CLK: in STD_LOGIC;
        T: out STD_LOGIC_VECTOR (0 to 9)
    );
end SequenceCounter;

architecture SequenceCounter_arch of SequenceCounter is
signal internal_count: std_logic_vector(0 to 9);
begin
T<=internal_count;
process (CLR_SC, CLK)
begin
	if (clk'event and clk='1') then
		if (CLR_SC = '1') then --Synchronous Sequence Counter
		internal_count<="1000000000";
		else
			if (internal_count="1000000000") then
				internal_count<="0100000000"; --T1
			elsif (internal_count="0100000000") then
				internal_count<="0010000000"; --T2
			elsif (internal_count="0010000000") then
				internal_count<="0001000000"; --T3	
			elsif (internal_count="0001000000") then
				internal_count<="0000100000"; --T4
			elsif (internal_count="0000100000") then
				internal_count<="0000010000"; --T5
			elsif (internal_count="0000010000") then
				internal_count<="0000001000"; --T6
			elsif (internal_count="0000001000") then
				internal_count<="0000000100"; --T7
			elsif (internal_count="0000000100") then
				internal_count<="0000000010"; --T8	
			elsif (internal_count="0000000010") then
				internal_count<="0000000001"; --T9
			elsif (internal_count="0000000001") then
				internal_count<="1000000000"; --T0
			end if;
		end if;
	end if;
	
end process;
end SequenceCounter_arch;
